<?php

function sm_image_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'image', $view_params );
}

function sm_register_shortcode_handler_sm_image() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-single-image.php' );
		class WPBakeryShortCode_sm_image extends WPBakeryShortCode_VC_Single_image {
			function content($atts, $content = null) {
				return sm_image_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_image', 'sm_image_func' );
	}
}

sm_register_shortcode( array(
	'name' => esc_html__( 'Image', 'semona-extension' ),
	'base' => 'sm_image',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Single Image', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-image.png',
	'params' => array(
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'semona-extension' ),
			'param_name' => 'image',
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Alt', 'semona-extension' ),
			'param_name' => 'alt',
			'value' => '',
			'description' => esc_html__( 'Specify Image Alt. Leave blank to use value from Media Library.', 'semona-extension' ),
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'semona-extension' ),
			'param_name' => 'title',
			'value' => '',
			'description' => esc_html__( 'Leave blank to use value from Media Library.', 'semona-extension' ),
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-8 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Align', 'semona-extension' ),
			'param_name' => 'align',
			'value' => sm_get_image_aligns_array(),
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image Action', 'semona-extension' ),
			'param_name' => 'action',
			'value' => sm_get_image_actions_array(),
			'description' => esc_html__( 'Choose what to do when you click on the image.', 'semona-extension' ),
		),

		array(
			'type' => 'textarea',
			'heading' => esc_html__( 'Image Description', 'semona-extension' ),
			'param_name' => 'image_text',
			'description' => esc_html__( 'Specify image description.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'action',
				'value' => array( 'sm-action-text' ),
			),
		),

		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Image Link', 'semona-extension' ),
			'param_name' => 'image_link',
			'description' => esc_html__( 'Specify image link.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'action',
				'value' => array( 'sm-action-link', 'sm-action-text' )
			),
			'edit_field_class' => 'vc_col-sm-8 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),
			'param_name' => 'open_new',
			'dependency' => array(
				'element' => 'action',
				'value' => array( 'sm-action-link', 'sm-action-text' )
			),
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),

		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Link Caption', 'semona-extension' ),
			'param_name' => 'image_link_caption',
			'dependency' => array(
				'element' => 'action',
				'value' => 'sm-action-text',
			),
		),

		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Lightbox Image', 'semona-extension' ),
			'param_name' => 'lightbox_image',
			'dependency' => array(
				'element' => 'action',
				'value' => 'sm-action-image',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Lightbox Video(Youtube/Vimeo) URL', 'semona-extension' ),
			'param_name' => 'lightbox_video',
			'dependency' => array(
				'element' => 'action',
				'value' => 'sm-action-video',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Lightbox ID', 'semona-extension' ),
			'param_name' => 'lightbox_id',
			'description' => esc_html__( 'Specify lightbox id. Images with same lightbox ids will create one lightbox gallery.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'action',
				'value' => array( 'sm-action-image', 'sm-action-video' ),
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Magnified Image', 'semona-extension' ),
			'param_name' => 'magnify_image',
			'dependency' => array(
				'element' => 'action',
				'value' => 'sm-action-magnify',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'On Hover Action', 'semona-extension' ),
			'param_name' => 'hover_action',
			'value' => sm_get_image_hover_actions_array(),
			'dependency' => array(
				'element' => 'action',
				'value_not_equal_to' => array( 'sm-action-magnify', 'sm-action-text' ),
			),
			'description' => esc_html__( 'Choose what to do on image hover.', 'semona-extension' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Hover Image', 'semona-extension' ),
			'param_name' => 'hover_image',
			'dependency' => array(
				'element' => 'hover_action',
				'value' => 'sm-hover-image',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),

		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Transition Effect', 'semona-extension' ),
			'param_name' => 'hover_transition',
			'dependency' => array(
				'element' => 'hover_action',
				'value' => 'sm-hover-image',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_image_styles_array()
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border color', 'semona-extension' ),
			'param_name' => 'border_color',
			'value' => sm_get_image_border_colors_array(),
			'std' => 'sm-grey-light',
			'dependency' => array(
				'element' => 'style',
				'value' => array( 'sm-style-border', 'sm-style-border-circle', 'sm-style-outline', 'sm-style-outline-circle' )
			),
			'description' => esc_html__( 'Border color.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class(),
		sm_css_box_option(),
	),
) );
